# 后端请求规范

## 与后台通信的功能列表
ueditor和后台通信的功能较多，这里列一下编辑器和后台通信的功能：

1. 上传图片
2. 拖放图片上传、粘贴板图片上传
3. word文档图片转存
4. 截图工具上传
5. 上传涂鸦
6. 上传视频
7. 上传附件
8. 在线图片管理
9. 粘贴转存远程图片

## 统一请求格式说明

为了规范化前后端通信的请求，这里统一规范前端请求格式和后端数据返回格式

* 前端请求通过唯一的后台文件 **controller.php**处理前端的请求
* **controller.php**通过GET上的action参数，判断是什么类型的请求
* 省去不必要的请求，去除涂鸦添加背景的请求，用前端FileReader读取本地图片代替
* 请求返回数据的格式，常规返回json字符串，数据包含state属性（成功时返回'SUCCESS'，错误时返回错误信息）。
* 请求支持jsonp请求格式，当请求有通过GET方式传callback的参数时，返回json数据前后加上括号，再在前面加上callback的值，格式类似这样：``` cb({"key": "value"})```

## 请求格式规范
以下是各类型的请求说明

### 1 config
请求参数:
```
GET {"action": "config"}
POST "upfile": File Data
```
返回格式:
```javascript
// 需要支持callback参数,返回jsonp格式
{
	"imageUrl": "http://localhost/ueditor/php/controller.php?action=uploadimage",
	"imagePath": "/ueditor/php/",
	"imageFieldName": "upfile",
	"imageMaxSize": 2048,
	"imageAllowFiles": [".png", ".jpg", ".jpeg", ".gif", ".bmp"]
}
```

### 2 uploadimage
请求参数:
```
GET {"action": "uploadimage"}
POST "upfile": File Data
```
返回格式:
```javascript
{
	"state": "SUCCESS",
    "url": "upload/demo.jpg",
	"title": "demo.jpg",
	"original": "demo.jpg"
}
```

### 3 uploadscrawl
请求参数:
```
GET {"action": "uploadscrawl"}
POST "content": Base64 Data
```
返回格式:
```javascript
{
	"state": "SUCCESS",
    "url": "upload/demo.jpg",
	"title": "demo.jpg",
	"original": "demo.jpg"
}
```
### 4 uploadvideo
请求参数:
```
GET {"action": "uploadvideo"}
POST "upfile": File Data
```
返回格式:
```javascript
{
	"state": "SUCCESS",
    "url": "upload/demo.mp4",
	"title": "demo.mp4",
	"original": "demo.mp4"
}
```

### 5 uploadfile
请求参数:
```
GET {"action": "uploadfile"}
POST "upfile": File Data
```
返回格式:
```javascript
{
	"state": "SUCCESS",
    "url": "upload/demo.zip",
	"title": "demo.zip",
	"original": "demo.zip"
}
```

### 6 listimage
请求参数:
```
GET {"action": "listimage", "start": 0, "size": 20}
```
返回格式:
```javascript
// 需要支持callback参数,返回jsonp格式
{
    "state": "SUCCESS",
    "list": [
        {"url": "upload/1.jpg"},
        {"url": "upload/2.jpg"},
    ],
    "start": 20,
    "total": 100
}
```

### 7 catchimage
请求参数:
```
GET {
    "action": "catchimage",
     "source": [
     	"http://a.com/1.jpg",
        "http://a.com/2.jpg"
    ]
}
```
返回格式:
```javascript
// 需要支持callback参数,返回jsonp格式
// list项的state属性和最外面的state格式一致
{
    "state": "SUCCESS",
    "list": [
        {
        	"url": "upload/1.jpg",
        	"source": "http://b.com/2.jpg",
        	"state": "SUCCESS"
        }, {
        	"url": "upload/2.jpg",
        	"source": "http://b.com/2.jpg",
        	"state": "SUCCESS"
        },
    ]
}
```